//Note: Details of scilab software version and OS version used:
//OS: Windows 7
//Scilab version: 5.4.1
//IPD Atom version:8.3.1-2
//SIVP Atom version:0.5.3.1-2
//5.PROGRAM TO IMPLEMENT DISCRETE FOURIER TRANSFORM
//DFT
clc;
close;
clear all;
N=input('Howmany point DFT  do you want?');
x2=input('Enter the sequence=');
n2=length(x2);
c= zeros(N);
x2=[x2 zeros(1,N-n2)];
 for k=1:N
     for n=1:N
         w=exp((-2*%pi*%i*(k-1)*(n-1))/N);
         x(n)=w;
         c(k,n)=x(n);
     end
     
 end
 r=x2*c;
//plotting magnitude and angle
subplot(2,1,1)
plot2d3('gnn',0:N-1,abs(r),2);
title('DFT-absolute value');
subplot(2,1,2)
a = gca()
plot2d3('gnn',0:N-1,atan(imag(r)./(real(r)+0.0001)),5);
a.x_location="origin";
title('DFT-angle');
disp(r,'Discrete Fourier Transform Result')
//RESULT
//Example 1
//Howmany point DFT  do you want? 4
//Enter the sequence=[1,2,3,4]
//Discrete Fourier Transform Result   
//    10.  - 2. + 2.i  - 2. - 9.797D-16i  - 2. - 2.i  
//
//Example 2
//Howmany point DFT  do you want?8
//Enter the sequence=[1,1,1,1,1,1,1,1]
//Discrete Fourier Transform Result   
//          column 1 to 5
// 
//    8.  - 5.551D-16 + 2.220D-16i  - 4.286D-16 - 4.441D-16i  - 2.220D-16 + 8.882D-16i  - 4.899D-16i  
// 
//         column 6 to 8
// 
//  - 2.109D-15 - 1.221D-15i  - 2.933D-15 - 6.661D-16i    3.553D-15 + 1.110D-15i
//
//Example 3
//Howmany point DFT  do you want? 8
//Enter the sequence= [0,1,2,3,4,5,6,7]
//Discrete Fourier Transform Result   
// 
// 
//         column 1 to 7
// 
//    28.  - 4. + 9.6568542i  - 4. + 4.i  - 4. + 1.6568542i  - 4. - 3.429D-15i  - 4. - 1.6568542i  - 4. - 4.i  
// 
//         column 8
// 
//  - 4. - 9.6568542i  
//
